﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports TailspinToysCRM

Public Class MainForm

    Private Sub cmdEdit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdEdit.Click
        Dim c As Customer
        Try
            Dim i As Integer = 14213
            c = Customer.EditCustomer(i)
        Catch exp As CustomerNotFoundException
            MsgBox(exp.Message, MsgBoxStyle.OkOnly, exp.AppSource)
        Catch exp As CustomerException
            MsgBox(exp.Message, MsgBoxStyle.OkOnly, exp.AppSource)
        Catch exp As Exception
            MsgBox(exp.Message, MsgBoxStyle.OkOnly, exp.Source)
        End Try
    End Sub

    Private Sub cmdDelete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdDelete.Click

        Try
            Dim i As Integer = 14213
            Customer.DeleteCustomer(i)

            ' 我们不会看到这些内容，这里只是为了完整性而将它们显示出来。
            MsgBox(String.Format("Customer Id {0} was deleted.", i), MsgBoxStyle.OKOnly, Me.Text)
        Catch exp As CustomerNotDeletedException
            Dim c As Customer
            c = exp.CustomerInfo
            ' 如果愿意，现在可以对客户做一些
            ' 更有趣的操作。
            MsgBox(exp.Message, MsgBoxStyle.OKOnly, exp.AppSource)
        Catch exp As CustomerException
            MsgBox(exp.Message, MsgBoxStyle.OKOnly, exp.AppSource)
        Catch exp As Exception
            MsgBox(exp.Message, MsgBoxStyle.OKOnly, exp.Source)
        End Try

    End Sub

    Private Sub cmdUntrapped_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdUntrapped.Click
        ' 通常情况下，Visual Basic 6.0 或早期版本中
        ' 未捕获的错误会导致立即弹出消息框，然后进程会
        ' 关闭。
        ' 实际上，Windows 窗体在 CLR 和代码
        ' 之间插入了一个顶级错误捕获。
        ' 您能否看到它们的对话取决于三个条件：
        ' 1) 是否有活动的调试器？
        ' 2) 是否有自己的异常处理程序可用？
        ' 3) 是否在应用程序的配置文件中打开了 JIT 调试（设置为 True）？

        ' 如果发生了未捕获的错误，并且对上述问题的回答
        ' 为“否”，则您会看到 Windows 窗体对话框，其中
        ' 为用户提供了选择“Continue”（继续）或“Quit”（退出）的机会。如果
        ' 是在“调试”模式下运行，则可以看到异常助手。
        ' 若要查看处理程序，您需要运行编译过的代码。

        Dim i As Short = 1234
        Dim j As Short = 0
        Dim k As Short = -1

        k = CShort(i / j)

        ' 您无法看到下面的 MsgBox 语句。
        MsgBox("Your results are: " & k.ToString(), MsgBoxStyle.OKOnly, Me.Text)
    End Sub

    Friend Sub OnThreadException(ByVal sender As Object, ByVal t As System.Threading.ThreadExceptionEventArgs)

    End Sub


    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub

    Friend ReadOnly Property ShouldTrapUnhandledException() As Boolean
        Get
            Return Me.chkGET.Checked
        End Get
    End Property
End Class
